/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Allegrex.compiler.nativeCode;

import jpcsp.Allegrex.compiler.nativeCode.AbstractNativeCodeSequence;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryWriter;

public class Memset
extends AbstractNativeCodeSequence {
    public static void call() {
        int dstAddr = Memset.getGprA0();
        int c = Memset.getGprA1() & 0xFF;
        int n = Memset.getGprA2();
        Memset.getMemory(dstAddr).memsetWithVideoCheck(dstAddr, (byte)c, n);
        Memset.setGprV0(dstAddr);
    }

    public static void call(int dstAddrReg, int cReg, int nReg) {
        Memset.call(dstAddrReg, cReg, nReg, 0);
    }

    public static void call(int dstAddrReg, int cReg, int nReg, int endValue) {
        int dstAddr = Memset.getRegisterValue(dstAddrReg);
        int c = Memset.getRegisterValue(cReg);
        int n = Memset.getRegisterValue(nReg) - endValue;
        Memset.getMemory(dstAddr).memsetWithVideoCheck(dstAddr, (byte)c, n);
        Memset.setRegisterValue(dstAddrReg, dstAddr + n);
        Memset.setRegisterValue(nReg, endValue);
    }

    public static void callMemset32() {
        int dstAddr = Memset.getGprA0();
        int c = Memset.getGprA1();
        int n = Memset.getGprA2();
        if (n > 0) {
            if ((c & 0xFF) == (c >> 8 & 0xFF) && (c & 0xFFFF) == (c >> 16 & 0xFFFF)) {
                Memset.getMemory(dstAddr).memsetWithVideoCheck(dstAddr, (byte)c, n);
            } else {
                IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(Memset.getMemory(dstAddr), dstAddr, n, 4);
                for (int i = 0; i < n; i += 4) {
                    memoryWriter.writeNext(c);
                }
                memoryWriter.flush();
            }
        }
        Memset.setGprV0(dstAddr + n);
    }

    public static void callWithStep(int dstAddrReg, int cReg, int nReg, int endValue, int direction, int step) {
        int dstAddr = Memset.getRegisterValue(dstAddrReg);
        int c = Memset.getRegisterValue(cReg);
        int n = (endValue - Memset.getRegisterValue(nReg)) * direction * step;
        Memset.getMemory(dstAddr).memsetWithVideoCheck(dstAddr, (byte)c, n);
        Memset.setRegisterValue(dstAddrReg, dstAddr + n);
        Memset.setRegisterValue(nReg, endValue);
    }

    public static void callWithStepReg(int dstAddrReg, int cReg, int nReg, int endValueReg, int direction, int step) {
        int endValue = Memset.getRegisterValue(endValueReg);
        Memset.callWithStep(dstAddrReg, cReg, nReg, endValue, direction, step);
    }
}

